﻿// load the file
function loadFile( filename:String, dest_array:Array, callTarget )
{
	trace("loadFile()");
	trace("this: "+this);
	trace("dest_array: "+dest_array);
	// create a movieClip to revieve new data  &  store load settings
	// // I use a movieClip because it persists beyond scope
	this.newData_obj = new Object();
	// Store parameters in the movieclip,  to preserve them across function calls
	newData_obj.dest_array = dest_array;		// store data destination
	newData_obj.callTarget = callTarget;			// store callback target
	//newData_obj.dest_array = new Array();		// clear old data
	newData_obj.newData = undefined;		// clear old data
	trace("erase:  newData_obj.newData = "+newData_obj.newData);
	trace("loading: "+filename+"   into: "+newData_obj);
	loadVariables(filename, newData_obj);
	newData_obj.callTarget.onLoadStart();		// Callback:  Loading has begun
	
	trace("");
	trace("- Checking object -");
	trace("newData_obj: "+newData_obj);
	trace("newData_obj.dest_array: "+newData_obj.dest_array);
	trace("newData_obj.callTarget: "+newData_obj.callTarget);
	trace("newData_obj.newData: "+newData_obj.newData);
	trace("");
	
	this.repeatCheckLoad = setInterval(checkLoad, 100);		// Periodically check if loading has finished
}


	
function checkLoad()
{
	trace("checkLoad()");
	trace("");
	trace("- Checking object -");
	trace("newData_obj: "+newData_obj);
	trace("newData_obj.dest_array: "+newData_obj.dest_array);
	trace("newData_obj.callTarget: "+newData_obj.callTarget);
	trace("newData_obj.newData: "+newData_obj.newData);
	trace("");
	for (index in newData_obj)
	{
		trace("Inside newData_obj:  "+index);
	}
	if (newData_obj.newData != undefined)
	{
		trace("done loading");
		trace("raw data:   "+newData_obj.newData);
		newData_obj.callTarget.onLoadComplete();		// Callback:	Loading was successful
		clearInterval(repeatCheckLoad);
		parseLoadedData();		// Read data into the specified array
	}else{
		trace("still loading");
		newData_obj.callTarget.onLoadProgress();			// Callback:	Loading has not completed yet  (for whatever reason)
	}
}
	
	
	
	// SUPPORT FUNCTIONS
function parseLoadedData()
{
	trace("newData_obj: "+newData_obj);
	trace("");
	trace("- Checking object -");
	trace("newData_obj: "+newData_obj);
	trace("newData_obj.dest_array: "+newData_obj.dest_array);
	trace("newData_obj.callTarget: "+newData_obj.callTarget);
	trace("newData_obj.newData: "+newData_obj.newData);
	trace("");
	//
	readCharacter = "";
	newName = "";
	for ( var i = 0; i < newData_obj.newData.length; i++)
	{
		readCharacter = newData_obj.newData.charAt(i);
		trace("readCharacter: "+readCharacter);
		trace("ascii code: "+newData_obj.newData.charCodeAt(i) );
		if (newData_obj.newData.charCodeAt(i) == 10 )
		{
			// It's the end of this line, so add the name
			if (newName != "")
			{
				newData_obj.dest_array.push( newName );
			}
			newName = "";
		}
		else if (newData_obj.newData.charCodeAt(i) == 13 )
		{
			// extra carriage return code, so ignore it
		}
		else
		{
			// assume this character is part of the current name, so add it
			newName += readCharacter;
		}// END if
	}// END for
	// if the file ends on something other than a carriage return, assume there's one more name to add

	// back up to look at the last character
	i--;
	if (newData_obj.newData.charCodeAt(i) != 13  &&  newData_obj.newData.charCodeAt(i) != 10 )
	{
		trace("index: "+i);
		trace("newName = "+newName);
		trace("ascii code: "+newData_obj.newData.charCodeAt(i));
		trace("it's not a carriage return, so there must be one more name, add it to the list.");
		newData_obj.dest_array.push( newName );
	}
	
	// Output
	trace("newData_obj.dest_array: "+newData_obj.dest_array);
	var output = newData_obj.dest_array;
	newData_obj.callTarget.onLoadInit( output );
	
	// CLEAN-UP
	delete newName;
	delete readCharacter;
	// // newData_obj...  just... won't...DIE!!  (removeMovieClip() doesn't work)   So just delete it's contents. 
	delete	newData_obj.dest_array;
	delete	newData_obj.callTarget;
	delete	newData_obj.newData;
	newData_obj.removeMovieClip();
	delete newData_obj;
}